module net.BurtonRadons.dedit.highlight.html;

import net.BurtonRadons.dedit.main;
import std.path;
import std.string;
import std.ctype;

alias std.ctype.isdigit isdigit;

/** The HTML highlighter. */
class HTML_Highlighter : SyntaxHighlighter
{
    const char [] symbols = "<>=/";

    static this ()
    {
        list ~= new HTML_Highlighter ();
    }

    override char [] name () { return "HTML"; }
    override char [] exts () { return "*.htm;*.html"; }

    override float match (char [] filename, char [] [] data)
    {
        char [] ext = std.string.tolower (std.path.getExt (filename));

        if (ext == "html" || ext == "htm")
            return 1;
        return 0;
    }

    final bit isSymbol (char f)
    {
        for (int c; c < symbols.length; c ++)
            if (f == symbols [c])
                return true;

        return false;
    }

    final bit isIdentifierStart (char f) { return isalpha (f) || f == '_'; }
    final bit isIdentifierMiddle (char f) { return isalnum (f) || f == '_' || f == '-'; }

    final char [] getKeyword (char *c, int n)
    {
        int d;

        if (n == 0 || !isIdentifierStart (*c))
            return null;
        for (d = 1; d < n; d ++)
            if (!isIdentifierMiddle (c [d]))
                break;

        return c [0 .. d];
    }
    
    struct LineInfo
    {
        char open;
            /**< Current open type:
               * <ul>
               * <li>'<' - open right-angle before keyword.
               * <li>'&' - character name.
               * <li>'>' - open right-angle after keyword.
               * <li>'"' - string nested inside a '>'.
               * <li>'!' - comment
               * <li>'#' - number nested inside a '>'.
               * </ul>
               */
    }

    /* We take the open code. */
    override int extraSize () { return LineInfo.size; }

    override void highlight (char [] line, char [] high, void *lastp, void *nextp)
    {
        LineInfo *last = (LineInfo *) lastp;
        LineInfo *next = (LineInfo *) nextp;
        char *c, h, e;
        char open;
        bit isInclude;

        if (last !== null)
            open = last.open;

        c = line;
        h = high;
        e = c + line.length;

        while (c < e)
        {
            int n = (int) (e - c);
            char f = *c;
            char [] r;

        restart:
            if (open == '!')
            {
                if (f == '>')
                {
                    *h ++ = 's', c ++;
                    open = 0;
                }
                else
                    *h ++ = '*', c ++;
            }
            else if (open == '"')
            {
                *h ++ = '"', c ++;
                if (f == '"')
                    open = '>';
            }
            else if (open == '#')
            {
                if (!isdigit (f))
                {
                    open = '>';
                    goto restart;
                }
                else
                    *h ++ = '#', c ++;
            }
            else if (open == '>')
            {
                if ((r = getKeyword (c, n)) !== null)
                {
                    h [0 .. r.length] = "m";
                    h += r.length;
                    c += r.length;
                }
                else if (isdigit (f) || f == '-')
                {
                    *h ++ = '#', c ++;
                    open = '#';
                }
                else if (isSymbol (f))
                {
                    *h ++ = 's', c ++;
                    if (f == '>')
                        open = 0;
                }
                else if (f == '"')
                {
                    *h ++ = '"', c ++;
                    open = '"';
                }
                else
                    *h ++ = 'i', c ++;
            }
            else if (open == '<')
            {
                if ((r = getKeyword (c, n)) !== null)
                {
                    h [0 .. r.length] = "r";
                    h += r.length;
                    c += r.length;
                    open = '>';
                }
                else if (f == '>')
                {
                    *h ++ = 's', c ++;
                    open = 0;
                }
                else if (f == '!')
                {
                    *h ++ = '*', c ++;
                    open = '!';
                }
                else if (isSymbol (f))
                    *h ++ = 's', c ++;
                else
                    *h ++ = 'i', c ++;
            }
            else if (open == '&')
            {
                *h ++ = '#', c ++;
                if (f == ';')
                    open = 0;
            }
        /* open == 0 from here on */
            else
            {
                if (f == '<')
                {
                    *h ++ = 's', c ++;
                    open = '<';
                }
                else if (f == '&')
                {
                    *h ++ = '#', c ++;
                    open = '&';
                }
                else
                    *h ++ = 0, c ++;
            }

        dun:
            continue;
        def:
            *h ++ = 0;
            c += 1;
        }

        if (open == '#')
            open = 0;

        next.open = open;
    }
}

